<?php
	function delta_item_trans($str) {
		$mst = $str;
		$small_str = '<span style="font-size:x-small;font-weight:normal"> - '.$str.'</span>';

		// 固有単語(1文字) - 項目
		if ( strtolower($str) == 'theme styles' ){return 'テーマ'.$small_str;}
		if ( strtolower($str) == 'custom styles' ){return 'カスタムスタイル'.$small_str;}
		if ( strtolower($str) == 'show' ){return '表示'.$small_str;}
		if ( strtolower($str) == 'hide' ){return '隠す'.$small_str;}
		if ( strtolower($str) == 'none' ){return '無し'.$small_str;}
		if ( strtolower($str) == 'Enabled' ){return '有効'.$small_str;}
		if ( strtolower($str) == 'Disabled' ){return '無効'.$small_str;}
		if ( strtolower($str) == 'underlined' ){return 'アンダーライン'.$small_str;}

		if ( strtolower($str) == 'all uppercase' ){return 'すべて大文字'.$small_str;}
		if ( strtolower($str) == 'all lowercase' ){return 'すべて小文字'.$small_str;}
		if ( strtolower($str) == 'capitalize first letter of each word' ){return '各単語の先頭を大文字に'.$small_str;}
		if ( strtolower($str) == 'no transformation' ){return '変換しない'.$small_str;}
		if ( strtolower($str) == 'theme default' ){return '既定のテーマ'.$small_str;}
		if ( strtolower($str) == 'Fixed width' ){return '固定幅'.$small_str;}
		if ( strtolower($str) == 'Fluid/Flexible width' ){return '流動的/フレキシブルな幅'.$small_str;}

		if ( preg_match("/Display full content/i",$str) ){return '全て表示'.$small_str;}
		if ( preg_match("/Display excerpt/i",$str) ){return '抜粋表示'.$small_str;}
		if ( preg_match("/Display list/i",$str) ){return '一覧表示'.$small_str;}
		if ( preg_match("/Display tiles/i",$str) ){return 'タイル表示'.$small_str;}
		if ( preg_match("/Display mosaic/i",$str) ){return 'モザイク表示'.$small_str;}

		if ( preg_match("/Always show/i",$str) ){return '常に表示する'.$small_str;}
		if ( preg_match("/Always hide/i",$str) ){return '常に表示しない'.$small_str;}

		if ( preg_match("/Footer is outside the main wrapper, its background and contents are as wide as your browser window/i",$str) )
			{return 'フッターをメインラッパーの外へ配置。その背景と内容をブラウザと同じ幅にする'.$small_str;}
		if ( preg_match("/Footer is outside the main wrapper, its background and contents are aligned with the main wrapper/i",$str) )
			{return 'フッターをメインラッパーの外へ配置。その背景と内容をメインラッパーに合わせる'.$small_str;}
		if ( preg_match("/Footer is outside the main wrapper, its background is as wide as your browser window, but footer contents are aligned with the main wrapper/i",$str) )
			{return 'フッターをメインラッパーの外へ配置。その背景はブラウザと同じ幅にするが、フッッターの内容はメインラッパーに合わせる'.$small_str;}
		if ( preg_match("/Footer is inside the main wrapper/i",$str) )
			{return 'フッターをメインラッパー内に配置。'.$small_str;}

		if ( preg_match("/Posted by \{author\} on \{date\} at \{time\}/i",$str) )	{return '投稿:{投稿者} on {日付} at {時間}'.$small_str;}
		if ( preg_match("/Posted by \{author\} at \{time\} \(Default\)/i",$str) )	{return '投稿:{投稿者} at {時間}'.$small_str;}
		if ( preg_match("/Posted by \{author\} on \{date\}/i",$str) )				{return '投稿:{投稿者} on {日付}'.$small_str;}
		if ( preg_match("/Posted by \{author\}/i",$str) )							{return '投稿:{投稿者}'.$small_str;}

		if ( preg_match("/Show (.+?) under title on the left side/i",$str,$sub) ){
			return delta_word_trans($sub[1]).'をタイトルの下、左側に配置'.$small_str;
		}else if ( preg_match("/Show (.+?) under title on the right side/i",$str,$sub) ){
			return delta_word_trans($sub[1]).'をタイトルの下、右側に配置'.$small_str;
		}else if ( preg_match("/Show (.+?) above footer on the left side/i",$str,$sub) ){
			return delta_word_trans($sub[1]).'をフッターの上、左側に配置'.$small_str;
		}else if ( preg_match("/Show (.+?) near footer on the right side/i",$str,$sub) ){
			return delta_word_trans($sub[1]).'をフッターの近く、右側に配置'.$small_str;
		}else if ( preg_match("/^Hide (.+?)$/i",$str,$sub) ){
			return delta_word_trans($sub[1]).'を表示しない'.$small_str;
		}

		// メタ情報（日付を含む）の位置
		if ( strtolower($str) == 'show in corners above/below content' ){return 'コンテンツ上/下の角に表示'.$small_str;}
		if ( strtolower($str) == 'pullout on the left (this will reduce your main column width)' )
			{return '左側から引き出す(メインカラムの幅が減少します)'.$small_str;}
		if ( strtolower($str) == 'pullout on the right side (this will reduce your main column width)' )
			{return '右側から引き出す(メインカラムの幅が減少します)'.$small_str;}
		if ( strtolower($str) == 'pullout on the left outside post (this will reduce your main column width)' )
			{return '投稿の左外側から引き出す(メインカラムの幅が減少します)'.$small_str;}
		if ( strtolower($str) == 'pullout on the right outside post (this will reduce your main column width)' )
			{return '投稿の右外側から引き出す(メインカラムの幅が減少します)'.$small_str;}
		if ( strtolower($str) == 'single line above post' ){return '投稿の上に一行'.$small_str;}
		if ( strtolower($str) == 'single line below post' ){return '投稿の下に一行'.$small_str;}

		$str = str_ireplace('Hide on search results. This is useful if your search returns a mix of pages and posts, because it makes the results look consistent (pages don\'t have a date box)'
		, '検索結果から隠す。検索結果に、ページや投稿記事が混ざる場合に便利です。何故なら見た目が一律になるからです。(ページはそもそも日付表示枠を持っていない)', $str);


//		if ( strtolower($str) == '' ){return ''.$small_str;}

//		$str = str_ireplace("top", '投稿書式', $str);


		if ( $mst != $str ){
			return $str.$small_str;
		}else{
			return $str;
		}
	}

	function delta_word_trans($str) {
		if ( strtolower($str) == 'permalinks' ) { return 'パーマリンク'; }
		if ( strtolower($str) == 'permalink' ) { return 'パーマリンク'; }
		if ( strtolower($str) == 'categories' ) { return 'カテゴリー'; }
		if ( strtolower($str) == 'comments link' ) { return 'コメントへのリンク'; }
		if ( strtolower($str) == 'posted by' ) { return '投稿者'; }
		if ( strtolower($str) == 'tags' ) { return 'タグ'; }
		return $str;
	}

	function delta_trans($str) {
		$mst = $str;
		$small_str = '<span style="font-size:x-small;font-weight:normal"> - '.$str.'</span>';
		if ( preg_match("/^(.+?) - (.+?)$/",$str,$sub) ){
			return delta_trans_sub($sub[1]) . ' - ' . delta_trans_sub($sub[2]) . $small_str;
		}

		$str = delta_trans_sub($str);
		if ( $mst != $str ){
			return $str.$small_str;
		}else{
			return $str;
		}

	}

	function delta_trans_sub($str) {
		$mst = $str;
		$back = '';

		if ( $str == 'Default or custom?' ){return 'デフォルトかカスタムか?';}

		// Introduction
		if ( $str == 'Welcome' ){return 'ようこそ!';}
		if ( $str == 'Don\'t Panic!!' ){return '慌てないで!';}
		if ( $str == 'Are you upgrading?' ){return 'アップグレードしてますか?';}
		if ( $str == 'Upgrades' ){return 'アップグレード';}
		if ( $str == 'Migrate settings from version 3.0.2 or lower' ){return 'version 3.0.2か、それ以前から設定を移行する';}
		if ( $str == 'Migrate settings from version 3.4.3 or lower' ){return 'version 3.4.3か、それ以前から設定を移行する';}
		if ( $str == 'Export / Import' ){return 'エクスポート / インポート';}
		if ( $str == 'Export core options for use in other installations' ){return '他への導入のためにコアオプションをエクスポート';}
		if ( $str == 'Export all options for use in other installations' ){return '他への導入のために全てのオプションをエクスポート';}
		if ( $str == 'Import options from another installation' ){return '他の導入システムからのインポート';}

		// Skinning - Theme selection
		if ( $str == 'Theme selection' ){return 'テーマ選択';}
		if ( $str == 'Color Scheme' ){return 'カラースキーム';}

		// Skinning - Icon Sets
		if ( $str == 'Icon Sets' ){return 'アイコンセット';}

		// Skinning - Header
		if ( $str == 'Default styles or custom styles for header?' ){return 'テーマを適用するか、カスタム設定を適用するか?';}
		if ( $str == 'Folder for Rotating Header background' ){return 'ローテーション表示の為のヘッダー背景用フォルダー';}
		if ( $str == 'Empty Space Between Top of Page and Header' ){return 'ページ上部とヘッダとの間の空きスペース';}
		if ( $str == 'Minimum Height of the Header image' ){return 'ヘッダー画像の最小の高さ';}

		// Skinning - Body Background
		if ( $str == 'Body Background' ){return 'ボディ(Webページ全体)の背景';}
		if ( $str == 'Default or custom backgrounds for main body?' ){return 'デフォルトかカスタムのメインボディの背景か?';}

		// Skinning - Main Wrapper
		if ( $str == 'Main Wrapper' ){return 'メインラッパー(ページ全体の大枠)';}
		if ( $str == 'Main Wrapper Background' ){return 'メインラッパーの背景';}

		// Skinning - Post Background

		// Skinning - Date Box
		if ( $str == 'Hide date box?' ){return '日付表示枠を隠す?';}

		// Skinning - Custom Emphasis Elements
		if ( $str == 'Custom elements to enhance page appearance' ){return 'ページの見た目を向上させるためのカスタム要素';}
		if ( $str == 'Default styles for emphasis elements?' ){return '強調要素はデフォルトスタイル?';}

		// Layouts - Default Sidebar Layout
//		if ( $str == 'The "Default" Sidebar layout' ){return '"デフォルトの"サイドバーレイアウト';}
		if ( $str == 'How many sidebars?' ){return '使用するサイドバー数は?';}

		if ( $str == 'Default sizes / margins for page elements?' ){return 'デフォの幅/ページ要素の余白?';}
		if ( $str == 'Fluid width settings' ){return '可変的な幅の設定';}

		if ( $str == 'Fixed width settings' ){return '固定的な幅の設定';}
		if ( $str == 'Overall Page Width' ){return '全体のページ幅';}
//		if ( $str == 'Custom value for page width' ){return 'ページ幅のカスタム値';}
		if ( $str == 'Custom component width' ){return 'カスタムコンポーネント幅';}

		if ( $str == 'Sidebar width settings' ){return 'サイドバーの幅設定';}

		// Layouts - Default Sidebar Layout
		if ( $str == 'The "No Sidebars" layout' ){return '"サイドバー無し"レイアウト';}
		if ( $str == 'Enable Widget Area Below Header?' ){return 'ヘッダーの下のウィジェット領域を有効にしますか？';}
		if ( $str == 'Enable Widget Area Above Footer?' ){return 'フッターの上のウィジェット領域を有効にしますか？';}

		// Layouts - Responsive Layouts
		if ( $str == 'Breakpoints' ){return 'ブレイクポイント';}
		if ( $str == 'Scaling' ){return 'スケーリング';}
		if ( $str == 'Switches' ){return 'スイッチ';}
		if ( $str == 'Header Foreground Images (Logos)' ){return 'ヘッダ前景画像(ロゴ)';}
		if ( $str == 'Navigation Menu' ){return 'ナビゲーションメニュー';}
		if ( $str == 'Excerpt thumbnails' ){return '引用サムネイル';}
//		if ( $str == 'Pullout-style bylines' ){return '';}

		// Layouts - Front / Blog Page Views
//		if ( $str == 'Front / Blog Page Views' ){return 'フロント/ブログページビュー';}
		if ( $str == 'Full content posts on first page / all pages (for selections above)' ){return 'トップページ・全ページ一覧での全文表示';}
		if ( $str == 'General Excerpt settings' ){return '抜粋設定(全般)';}
		if ( $str == 'Number of words in auto-generated excerpts' ){return '抜粋表示時の文字数';}
		if ( $str == '"Read more" style' ){return '"続きを読む"の表示スタイル';}
		if ( $str == '"Read more" text in excerpts' ){return '抜粋表示時の"続きを読む"リンクの文字列';}
		if ( $str == '"Number of Full content posts on Front Page' ){return 'フロントページ上の全コンテンツ投稿数';}

		// Layouts - Layout: Excerpt / List / Tile / Mosaic / Full
		if ( $str == 'Show thumbnails for excerpts' ){return '抜粋表示時にサムネイルも表示';}
		if ( $str == 'Show featured images for full content' ){return '全文表示時に注目画像を表示';}
		if ( $str == 'Image preference order' ){return '画像の優先順位';}
		if ( $str == 'Set compression quality' ){return '圧縮品質を設定';}
		if ( $str == 'Thumbnail alignment in excerpts' ){return '抜粋表示時のサムネイル位置';}
		if ( $str == 'Thumbnail size in excerpts' ){return '抜粋表示時のサムネイルサイズ';}
//		if ( $str == 'Custom width of thumbnail' ){return 'サムネイルのカスタム幅';}
//		if ( $str == 'Custom height of thumbnail' ){return 'サムネイルのカスタム高さ';}

		if ( $str == 'Number of posts in "Display List" option' ){return '表示する投稿文書数';}
		if ( $str == 'List style in "Display List" option' ){return '表示順序';}

		if ( $str == 'Number of excerpts per row in "Display Tiles" option' ){return '1行に表示する投稿文書数';}
		if ( $str == 'Thumbnail container for excerpts' ){return 'サムネイル表示';}
		if ( $str == 'Thumbnail container height for excerpts' ){return 'サムネイルの高さ';}
//		if ( $str == 'Thumbnail image and size settings' ){return 'サムネイル画像とサイズの設定';}
		if ( $str == 'Tile thumbnail image scaling' ){return 'タイルサムネイルのスケール';}
		if ( $str == 'Custom height of thumbnail image in tiles' ){return 'タイルサムネイルの高さ';}
		if ( $str == 'Custom width of thumbnail image in tiles' ){return 'タイルサムネイルの幅';}
		if ( $str == 'Alignment of post title in Excerpts' ){return 'タイトルの位置';}

		if ( $str == 'Show bylines for tiled excerpts' ){return 'Show bylines for tiled excerpts';}

		if ( $str == 'Proportional resizing' ){return 'プロポーショナルリサイズ';}
		if ( $str == 'Constrain the number of thumbnails per row' ){return '行あたりのサムネイル数を制限';}
		if ( $str == 'Constrain by padding' ){return '回り込み(Padding)の制約';}
		if ( $str == 'Constrain by number of thumbnails' ){return 'サムネイル数の制約';}
		if ( $str == 'Allow thumbnail zooming' ){return 'サムネイルからの拡大の許可';}
		if ( $str == 'Zooming library if zooming is allowed' ){return '拡大許可の場合のズームライブラリ';}
//		if ( $str == 'Show post title below thumbnail?' ){return '投稿タイトルの下にサムネイルを表示しますか?';}

		// Typography - Body Fonts
		if ( $str == 'Default or custom font styles?' ){return 'デフォルトかカスタムスタイルか';}
		if ( $str == 'Main Content' ){return 'メインコンテンツ';}
		// Typography - Post and Page Titles
//		if ( $str == 'Post and Page Titles' ){return '投稿とページのタイトル';}
		if ( $str == 'Unlinked post titles' ){return '投稿タイトル(リンクではない)';}
		if ( $str == 'Linked post titles' ){return '投稿タイトル(リンクになっている)';}
		// Typography - Drop Caps
		if ( $str == 'Drop Caps' ){return '本文の先頭一文字だけ大きく';}
		if ( $str == 'Applicable post views' ){return '対象とする表示形式';}
		if ( $str == 'Applicable post formats' ){return '対象とする文書書式';}

		// Sidebar
		$str = preg_replace("/Top Bar Right Widgets/iu"	,"トップバー内(右)のウィジェット",$str);
		$str = preg_replace("/Top Bar Left Widgets/iu"	,"トップバー内(左)のウィジェット",$str);
		$str = preg_replace("/Widgets Above Header/iu"	,"ヘッダーの上のウィジェット",$str);
		$str = preg_replace("/Widgets In Header/iu"		,"ヘッダー内(上)のウィジェット",$str);
		$str = preg_replace("/Right Header Widgets/iu"	,"ヘッダー内(右)のウィジェット",$str);
		$str = preg_replace("/Widget Area Below Header/iu","ヘッダーの下のウィジェットエリア",$str);
		$str = preg_replace("/Widget Area Above Footer/iu","ヘッダーの上のウィジェットエリア",$str);
		$str = preg_replace("/Ad Hoc Widgets/iu"			,"非定型ウィジェット",$str);
		$str = preg_replace("/Static Tabbed Sidebar/iu"	,"静的タブサイドバー",$str);

		$str = preg_replace("/^Style of \"(.+?)\" widget area$/iu","\"\\1\"ウィジェットエリアのスタイル",$str);
		$str = preg_replace("/^Layout Style for \"(.+?)\" widget area$/iu","\"\\1\"ウィジェットエリアのレイアウトスタイル",$str);
		$str = preg_replace("/^Title styling of widgets in \"(.+?)\" area$/iu","\"\\1\"エリア内のタイトルスタイル",$str);
		$str = preg_replace("/^Sliding Panel \"(.+?)\" text$/iu","スライドパネル\"\\1\"の文字",$str);

		if ( $str == 'Width of Widget Area in Header' ){return 'ヘッダ内のウィジェット内の幅';}
		if ( $str == 'Show Search in Widget Area on right side of header' ){return 'ヘッダ内の右端のウィジェットエリアに検索枠を表示';}
		if ( $str == 'Default or custom font styles for sidebar?' ){return 'サイドバーのフォントスタイルは、デフォルトかカスタムか';}
		if ( $str == 'Default or custom font styles for widget area below header?' ){return 'ヘッダーの下のウィジェットエリアのフォントスタイルは、デフォルトかカスタムか';}
		if ( $str == 'Default or custom font styles for widget area above footer?' ){return 'ヘッダーの上のウィジェットエリアのフォントスタイルは、デフォルトかカスタムか';}
		if ( $str == 'Look and Feel' ){return '見た感じ';}
		if ( $str == 'Order of tabs in Tabbed Sidebar' ){return 'タブサイドバー内のタブの順序';}
		if ( $str == 'Use JQuery Masonry?' ){return 'JQuery Masonryを使いますか?';}
		if ( $str == 'List categories hierarchically?' ){return 'カテゴリ階層をリストする?';}
//		if ( $str == 'Show post count for each category?' ){return 'カテゴリごとの投稿数を表示しますか?';}
//		if ( $str == 'Show post count for each archive?' ){return 'アーカイブごとの投稿数を表示しますか?';}

		// Other Graphical Elements
//		if ( $str == 'Order of entities in navigation bar' ){return 'ナビゲーションバー項目の順序';}
		if ( $str == 'Select pages to show in Navigation Bar' ){return 'ナビゲーションバーに表示するページを選択してください';}
		if ( $str == 'All or Selected' ){return '全てか選択か';}
//		if ( $str == 'Select categories to show in Navigation Bar' ){return 'ナビゲーションバーに表示するカテゴリを選択してください';}
		if ( $str == 'WordPress Link listing style in the Navigation Bar' ){return 'ナビゲーションバー内にWordPressリンクのリストスタイル';}

//		if ( $str == 'Select links to show in Navigation Bar' ){return 'ナビゲーションバーに表示するリンクを選択してください';}

		if ( $str == 'WP 3.0 Navigation Menus' ){return 'WP 3.0 ナビゲーションメニュー';}
//		if ( $str == 'Select Menus to show' ){return '表示するメニューを選択してください';}

		if ( $str == '"Title" attribute upon hovering over navigation bar' ){return 'ナビゲーションバー上をHover中に"タイトル"属性';}
		if ( $str == 'Text in left part of footer' ){return 'フッターの左部分のテキスト';}
		if ( $str == 'Text in central part of footer' ){return 'フッターの中央部分のテキスト';}
		if ( $str == 'Posts (Default/Standard post format)' ){return '投稿(デフォルト/標準投稿書式)';}
		if ( $str == 'Position of meta information (including date)' ){return 'メタ情報（日付を含む）の位置';}
		if ( $str == 'Show Permalink for posts without titles?' ){return 'タイトルなしで投稿のパーマリンクを表示しますか？';}
		if ( $str == 'Show Permalink for posts without title?' ){return 'タイトルなしで投稿のパーマリンクを表示しますか？';}
		if ( $str == 'Show Permalink for posts with titles?' ){return '投稿のタイトルのパーマリンクを表示しますか？';}
		if ( $str == 'Show Permalink for posts with title?' ){return '投稿のタイトルのパーマリンクを表示しますか？';}
		if ( $str == '"Posted By" format' ){return '"投稿者"の表示書式';}
//		if ( $str == 'Show Title?' ){return 'タイトルを表示?';}

		if ( $str == 'Disable Gallery Post Format in archives' ){return 'アーカイブ内のギャラリー投稿書式を無効';}
		if ( $str == 'Gallery posts in archives' )	{return 'ギャラリー投稿アーカイブ';}
//		if ( $str == 'Number of thumbnails to show' )	{return '表示するサムネイルの数';}
		if ( $str == 'Random thumbnails' ){return 'ランダムサムネイル';}
		if ( $str == 'Byline Configuration' ){return '署名欄の設定';}
		if ( $str == 'Where to Show' ){return '表示する場所';}
		if ( $str == 'Time archive view' ){return '時間別アーカイブ表示';}
		if ( $str == 'First page / all pages' ){return 'はじめのページ/全てのページ';}
		if ( $str == 'Static Pages with Featured Content' ){return '注目のコンテンツと静的ページ';}
		if ( $str == 'What to Show' ){return '何を表示する';}
		if ( $str == 'Number of Posts' ){return '投稿数';}
//		if ( $str == 'Show Duplicate Posts' ){return '重複投稿を表示';}
//		if ( $str == 'Show Sticky Posts' ){return '付箋投稿を表示';}
		if ( $str == 'Show Latest Posts?' ){return '最新の投稿を表示しますか？';}
		if ( $str == 'Number of Latest Posts' ){return '最新の投稿数';}
//		if ( $str == 'Select Categories' ){return 'カテゴリーを選択';}
//		if ( $str == 'Select Pages' ){return 'ページを選択';}
//		if ( $str == 'Posts to show' ){return '表示する投稿';}
//		if ( $str == 'Tags to show' ){return '表示するタグ';}
		if ( $str == 'How to Show' ){return '表示する方法';}
		if ( $str == 'Transition Effects' ){return '切り替え効果';}
		if ( $str == 'Image synchronization' ){return '画像の同期';}
		if ( $str == 'Time for each post display' ){return '各投稿表示の時間';}
		if ( $str == 'Transition speed for post' ){return '投稿の遷移速度';}
		if ( $str == 'Display Text' ){return '文書表示';}
		if ( $str == 'Position of Text' ){return '文書の位置';}
		if ( $str == 'Featured content skinning' ){return '注目のコンテンツのスキン';}
		if ( $str == 'Height of the Featured Posts section' ){return '注目ページ選択の高さ';}
		if ( $str == 'Image size in featured content' ){return '注目のコンテンツの画像サイズ';}
		if ( $str == 'Custom width of featured image' ){return '注目の画像のカスタム幅';}
		if ( $str == 'Custom height of featured image' ){return '注目の画像のカスタム高さ';}
		if ( $str == 'Stretch smaller images' ){return '小さな画像を引き伸ばす';}
		if ( $str == 'Center images' ){return '中央の画像';}
		if ( $str == 'Pause, Previous and Next Controls' ){return '停止,進める,次への制御';}
		if ( $str == 'Pause, Previous and Next Controls Alignment' ){return '停止,進める,次への制御の位置';}
		if ( $str == 'Excluded pages in breadcrumb' ){return 'パンくずリストで除外されたページ';}
		if ( $str == 'Breadcrumb Separator' ){return 'パンくずリストのセパレータ';}
		if ( $str == 'Page x of y' ){return 'ページx(yページ中)';}
		if ( $str == 'Above / below post?' ){return '上/下の投稿？';}
		if ( $str == 'Miscellaneous' ){return 'いろいろ';}
		if ( $str == 'Use Rounded Corners?' ){return '角丸コーナーを使用しますか？';}
		if ( $str == 'Image Aspect Ratio' ){return '画像の縦横比';}
		if ( $str == 'Use JetPack Photon for Resizing' ){return 'サイズ変更にJetPack Photonを利用';}
		if ( $str == 'Thumbnail Generation' ){return 'サムネイル生成';}

		// Back-End - SEO / Meta Settings
		if ( $str == 'Force IE7 Compatibility View' ){return '強制IE7の互換表示';}
		if ( $str == 'Enable SEO settings for the theme?' ){return 'テーマのSEO設定を有効にしますか？';}
		if ( $str == 'Select Meta tags' ){return 'メタタグを選択';}
		if ( $str == 'Blog description / subtitle in page title on home page' ){return 'ホームページのページタイトルに、ブログ説明/サブタイトル';}
		if ( $str == 'Page numbers in title' ){return 'タイトルにページ番号';}

		// Back-End - Comment Settings
		if ( $str == 'Hide "Comment form closed" Message on Pages' ){return 'ページ内の"コメント欄は閉じた"メッセージを隠す';}
		if ( $str == 'Hide "Comment form closed" Message on Posts' ){return '投稿内の"コメント欄は閉じた"メッセージを隠す';}
		if ( $str == 'Select pages to hide "Comment form closed" message' ){return '"コメント欄は閉じた"のメッセージを非表示にするページを選択してください';}
		if ( $str == 'Show Trackbacks and Pingbacks?' ){return 'トラックバックとピングバックを表示しますか？';}
		if ( $str == 'Allow Replies for Trackbacks and Pingbacks?' ){return 'トラックバックとピングバックの返信を許可しますか？';}

		// Back-End - User Profiles
		if ( $str == 'User Profiles' ){return 'ユーザプロファイル';}
		if ( $str == 'Select Additional Social Networks' ){return '追加のソーシャルネットワークを選択してください';}
		if ( $str == 'Show author information for individual posts and pages' ){return '個々の記事やページに対する著者の情報を表示します';}
		if ( $str == 'Author information header' ){return '著者情報ヘッダ';}
		if ( $str == 'Author Gravatar' ){return '著者Gravatar';}
		if ( $str == 'Gravatar Size' ){return 'Gravatarサイズ';}
		if ( $str == 'Author information content' ){return '著者情報コンテンツ';}
		if ( $str == 'Custom Google Analytics Tracking Code' ){return 'Google Analyticsのトラッキングコード';}
		if ( $str == 'OpenID Setup' ){return 'OpenID設定';}
		if ( $str == 'Enable OpenID support?' ){return 'OpenIDのサポートを有効にしますか？';}
		if ( $str == 'OpenID Server' ){return 'OpenIDサーバ';}
		if ( $str == 'OpenID Delegate' ){return 'OpenIDデリゲート';}

		// Back-End - Custom Includes
		if ( $str == 'Custom Includes' ){return 'Custom Includes';}
		if ( $str == 'Don\'t like the default styles? Add your own...' ){return 'デフォルトのスタイルが好きではないのですか？あなた自身で追加...';}
		if ( $str == 'First Additional Stylesheet link' ){return '一つ目のスタイルシートのリンク';}
		if ( $str == 'Second Additional Stylesheet link' ){return '二つ目のスタイルシートのリンク';}
		if ( $str == 'Third Additional Stylesheet link' ){return '三つ目のスタイルシートのリンク';}
		if ( $str == 'Got JavaScript?' ){return 'JavaScriptを使用しましたか？';}
		if ( $str == 'First External JavaScript file' ){return '一つ目の外部JavaScriptファイル';}
		if ( $str == 'Second External JavaScript file' ){return '二つ目の外部JavaScriptファイル';}
		if ( $str == 'Third External JavaScript file' ){return '三つ目の外部JavaScriptファイル';}
		if ( $str == 'Custom Header JavaScript' ){return 'ヘッダーへ挿入するカスタムJavaScript';}
		if ( $str == 'Custom Footer JavaScript' ){return 'フッダーへ挿入するカスタムJavaScript';}
		if ( $str == 'Additional Auto-discovery RSS / Atom feeds' ){return '追加の自動検出するRSS / Atomフィード';}
		if ( $str == 'Disable default feed?' ){return 'デフォのフィードを停止する?';}
		if ( $str == 'Maximum Number of excerpts per row' ){return '行ごとの抜粋の最大数';}
		if ( $str == 'Maximum number of excerpts' ){return '抜粋の最大数';}

		// Back-End - Modules
		if ( $str == 'Modules' ){return 'モジュール';}
		if ( $str == 'Disable Widgets' ){return '無効にするウィジェット';}

		// Back-End - Site Optimization
		if ( $str == 'Site Optimization' ){return 'サイトの最適化';}
		if ( $str == 'Auto-generate CSS file for customization options' ){return '自動生成CSSファイルのカスタマイズオプション';}
		if ( $str == 'Minify generated CSS' ){return '小さなCSSを生成';}
		if ( $str == 'Use "Lite" version of JQuery Cycle?' ){return 'JQueryライト版';}
		if ( $str == 'Child Themes' ){return '子テーマ';}
		if ( $str == 'Inherit styles?' ){return 'スタイルを継承？';}
		if ( $str == 'Show an excerpts section for the magazine template' ){return 'マガジンテンプレートの抜粋部分を表示';}


		// Templates
		if ( $str == 'Number of Full content posts on "Page of Posts" template' ){return '"投稿のページ"テンプレート上の全コンテンツの投稿数';}
		if ( $str == 'Enable Category Introduction?' ){return 'カテゴリー概要を有効にしますか?';}
//		if ( $str == 'EXIF data to display' ){return '表示するEXIFデータ';}
		if ( $str == 'Number of Books per row' ){return '行あたりの冊数';}
		if ( $str == 'Text if no books are found for a section' ){return 'Text if no books are found for a section';}
		if ( $str == 'Display Currently Reading Books' ){return '既読書籍を表示する';}
		if ( $str == 'Section title for Currently Reading Books' ){return '既読書籍のセクションタイトル';}
		if ( $str == 'Section text for Currently Reading Books' ){return '既読書籍のセクション文書';}
		if ( $str == 'Display Unread Books' ){return '読んでいない書籍を表示';}
		if ( $str == 'Section title for Unread Books' ){return '未読の書籍のセクションタイトル';}
		if ( $str == 'Section text for Unread Books' ){return '未読の書籍のセクションテキスト';}
		if ( $str == 'Reading statistics: Show when book was added to library' ){return '読み込み統計:本がライブラリに追加されたときに表示';}
		if ( $str == 'Reading statistics: Tagline for when you added this book' ){return '読み込み統計:この本を追加したときのためのキャッチフレーズ';}
		if ( $str == 'This text will be displayed below the book\'s image' ){return 'このテキストは、書籍の画像の下に表示されます';}
		if ( $str == 'Reading statistics: Tagline for when you began reading this book' ){return '読み込み統計:あなたはこの本を読み始めたときのャッチフレーズ';}
		if ( $str == 'Default or custom skinning?' ){return 'デフォルトかカスタムスキンか?';}
		if ( $str == 'I Have Moved!!' ){return '移動しました!!';}
		if ( $str == '' ){return '';}
		if ( $str == '' ){return '';}
		if ( $str == '' ){return '';}

		// 長い文で始まる
		$str = preg_replace("/^Number of Full content posts for (.+?)$/iu","\\1で投稿文全てを表示する数",$str);
		$str = preg_replace("/relative to (.+?)$/iu","\\1を基準",$str);
		$str = preg_replace("/^Options for paged navigation of (.+?)$/iu","\\1のページングナビゲーションのオプション",$str);
		$str = preg_replace("/^Show all (.+?) in listing$/iu","リスト内のすべての\\1を表示する",$str);

		if ( preg_match("/^Enable (.+?)\?$/ui",$str,$sub) ){ $back = 'を有効にしますか?'; $str = $sub[1]; }
		if ( preg_match("/^Enable (.+?)$/ui",$str,$sub) ){ $back = 'を有効'; $str = $sub[1]; }
		if ( preg_match("/^Showing (.+?)$/ui",$str,$sub) ){ $back = 'を表示'; $str = $sub[1]; }
		if ( preg_match("/^Show \/ Hide (.+?)$/ui",$str,$sub) ){ $back = 'を表示/非表示'; $str = $sub[1]; }
		if ( preg_match("/^Show (.+?)\?$/ui",$str,$sub) ){ $back = 'を表示しますか?'; $str = $sub[1]; }
		if ( preg_match("/^Show (.+?)$/ui",$str,$sub) ){ $back = 'を表示します'; $str = $sub[1]; }
		if ( preg_match("/^Select (.+?)$/ui",$str,$sub) ){ $back = 'を選択'; $str = $sub[1]; }
		if ( preg_match("/^Display (.+?)\?$/ui",$str,$sub) ){ $back = 'を表示しますか?'; $str = $sub[1]; }
		if ( preg_match("/^Display (.+?)$/ui",$str,$sub) ){ $back = 'を表示します'; $str = $sub[1]; }

		// 1単語で始まる
		$str = preg_replace("/^No (.+?)$/iu","\\1無し",$str);
		$str = preg_replace("/^Restrict (.+?)$/iu","\\1を制限",$str);

		// 3単語で終わる
		$str = preg_replace("/^(.+?) Background Image Type$/iu","\\1の背景画像タイプ",$str);
		$str = preg_replace("/^(.+?) Background Image Tiling$/iu","\\1の背景画像のタイル表示",$str);
		$str = preg_replace("/^(.+?) Background Image Position$/iu","\\1の背景画像の位置",$str);
		$str = preg_replace("/^(.+?) Background Gradient Style$/iu","\\1の背景グラデーションスタイル",$str);
		$str = preg_replace("/^(.+?) Background Gradient Start Color$/iu","\\1の背景グラデーション色(始)",$str);
		$str = preg_replace("/^(.+?) Background Gradient End Color$/iu","\\1の背景グラデーション色(終)",$str);
		$str = preg_replace("/^(.+?) Foreground Image Type$/iu","\\1の前景画像タイプ",$str);

		// 2単語で終わる
		$str = preg_replace("/^(.+?) Border Color$/iu","\\1の境界色",$str);
		$str = preg_replace("/^(.+?) Font Color$/iu","\\1の文字色",$str);
		$str = preg_replace("/^(.+?) Background Image$/iu","\\1の背景画像",$str);
		$str = preg_replace("/^(.+?) Background Color$/iu","\\1の背景色",$str);
		$str = preg_replace("/^(.+?) Background Font$/iu","\\1の背景フォント",$str);
		$str = preg_replace("/^(.+?) Foreground Image$/iu","\\1の前景画像",$str);
		$str = preg_replace("/^(.+?) Layout Bylines$/iu","\\1の表示設定",$str);
		$str = preg_replace("/^(.+?) form title$/iu","\\1のタイトル",$str);
		$str = preg_replace("/^(.+?) to show$/iu","表示する\\1",$str);
		$str = preg_replace("/^(.+?) to Display$/iu","表示する\\1",$str);
		
		// 1単語で終わる
		$str = preg_replace("/^(.+?) Background$/iu","\\1の背景",$str);
		$str = preg_replace("/^(.+?) Border$/iu","\\1の境界線",$str);
		$str = preg_replace("/^(.+?) Font$/iu","\\1のフォント",$str);
		$str = preg_replace("/^(.+?) Views$/iu","\\1表示",$str);
		$str = preg_replace("/^(.+?) View$/iu","\\1表示",$str);
		$str = preg_replace("/^(.+?) settings$/iu","\\1の設定",$str);
		$str = preg_replace("/^(.+?) layout$/iu","\\1のレイアウト",$str);
		$str = preg_replace("/^(.+?) Decoration$/iu","\\1の装飾",$str);
		$str = preg_replace("/^(.+?) Face$/iu","\\1の種類",$str);
		$str = preg_replace("/^(.+?) skinning$/iu","\\1のスキン",$str);
		$str = preg_replace("/^(.+?) Before and After$/iu","\\1の前後",$str);
		$str = preg_replace("/^(.+?) Before$/iu","\\1の前",$str);
		$str = preg_replace("/^(.+?) After$/iu","\\1の後",$str);

		// 固有単語(4文字以上)
		$str = str_ireplace("Navigation Menu Items", "ナビゲーションメニュー項目", $str);
		$str = str_ireplace("1 Left, 1 Right Sidebar", '左右一つずつのサイドバー', $str);
		$str = str_ireplace("1 Left and 1 Right Sidebar", '左右一つずつのサイドバー', $str);

		// 固有単語(3文字)
//		$str = str_ireplace("Width of page", 'ページの幅', $str);

		$str = str_ireplace("1 Left Sidebar", '左サイドバー1つ', $str);
		$str = str_ireplace("2 Left Sidebars", '左サイドバー2つ', $str);
		$str = str_ireplace("1 Right Sidebar", '右サイドバー1つ', $str);
		$str = str_ireplace("2 Right Sidebars", '右サイドバー2つ', $str);
		$str = str_ireplace("lower first sidebar", 'サイドバー1(下)', $str);
		$str = str_ireplace("lower second sidebar", 'サイドバー2(下)', $str);

		// 固有単語(2文字)
		$str = str_ireplace("Blog Title", "ブログタイトル", $str);
		$str = str_ireplace("Blog Description", "ブログの概要", $str);
		$str = str_ireplace("Page of Posts", "投稿ページ", $str);

		$str = str_ireplace("Sidebar 1", 'サイドバー1', $str);
		$str = str_ireplace("Sidebar 2", 'サイドバー2', $str);
		$str = str_ireplace("first sidebar", 'サイドバー1', $str);
		$str = str_ireplace("second sidebar", 'サイドバー2', $str);
		$str = str_ireplace("wide sidebar", 'ワイドサイドバー', $str);
		$str = str_ireplace("Sliding Panel", 'スライドパネル', $str);
		$str = str_ireplace("Tabbed Sidebar", 'タブサイドバー', $str);

		$str = str_ireplace("post date", '投稿日', $str);
		$str = str_ireplace("Posted by", '投稿者', $str);
		$str = str_ireplace_s("Post Format", '投稿書式', $str);
		$str = str_ireplace_s("post format", '投稿書式', $str);
		$str = str_ireplace_s("Post Index", '投稿インデックス', $str);
		$str = str_ireplace("Full posts", '全て表示', $str);

		$str = str_ireplace("Date Archive", '日別アーカイブ', $str);
		$str = str_ireplace("Date Box", '日付表示枠', $str);

		$str = str_ireplace("the Navigation Bar", "ナビゲーションバー", $str);
		$str = str_ireplace("Navigation Bar", "ナビゲーションバー", $str);
		$str = str_ireplace_s("Breadcrumb Navigation", "パンくずリストナビゲーション", $str);
		$str = str_ireplace_s("Navigation Breadcrumb", "パンくずリストナビゲーション", $str);
		$str = str_ireplace("Page Navigation", 'ページナビゲーション', $str);

		$str = str_ireplace("Featured Content", '注目のコンテンツ', $str);
		$str = str_ireplace("Featured Posts", '注目の投稿', $str);

		$str = str_ireplace("Search Result", '検索結果', $str);
		$str = str_ireplace("widget area", 'ウィジェットエリア', $str);
		$str = str_ireplace("Title styling", 'タイトルスタイル', $str);
		$str = str_ireplace("Meta Title", 'メタタイトル', $str);
		$str = str_ireplace("Tag Cloud", 'タグクラウド', $str);
		$str = str_ireplace("Basic Setup", '基本設定', $str);
		$str = str_ireplace("Drop-down menu", 'ドロップダウンメニュー', $str);
		$str = str_ireplace("Menu Item", 'メニュー項目', $str);
		$str = str_ireplace("Fade effect", 'フェード効果', $str);
		$str = str_ireplace("Text Transformation", '文字変換', $str);
		$str = str_ireplace("Comments link", 'コメントへのリンク', $str);
		$str = str_ireplace_s("Numbered Listing", "番号付きリスト", $str);
		$str = str_ireplace("individual thumbnail", '個々のサムネイル', $str);
		$str = str_ireplace("Thumbnail panel", 'サムネイルパネル', $str);
		$str = str_ireplace("Comment form", 'コメント欄', $str);

		$str = str_ireplace("First Additional", '一つ目', $str);
		$str = str_ireplace("Second Additional", '二つ目', $str);
		$str = str_ireplace("Third Additional", '三つ目', $str);
		$str = str_ireplace_s("RSS Feed", 'RSSフィード', $str);
		$str = str_ireplace_s("ATOM Feed", 'ATOMフィード', $str);
		$str = str_ireplace("image box", 'イメージボックス', $str);
		$str = str_ireplace("category blocks", 'カテゴリーブロック', $str);
 		$str = str_ireplace_s("EXIF data", "EXIF情報", $str);
 		$str = str_ireplace_s("Now Reading", "読み込み中", $str);
 		$str = str_ireplace_s("book cover", "ブックカバー", $str);
 		$str = str_ireplace_s("Unread Books", "未読の書籍", $str);
 		$str = str_ireplace_s("Currently Reading Books", "読書中の書籍", $str);
 		$str = str_ireplace_s("Completed Books", "既読書籍", $str);

 		$str = str_ireplace_s("Emphasis Elements", "強調要素", $str);


//		$str = str_ireplace("Maximum width", '最大幅', $str);
//		$str = str_ireplace("Minimum width", '最小幅', $str);

		// 接続語など
		$cnt = 10;
		while( $cnt > 0 ){
			if ( preg_match("/^(.+?) (in|or|and|above|below|of|for|from|on) (.+?) (in|or|and|above|below|of|for|from|on) (.+?)$/ui",$str,$sub) ){
				$sw = $sub[1] . ' ' . $sub[2] . ' ';
				$aw = strtolower($sub[3]);
				$jw = strtolower($sub[4]);
				$bw = strtolower($sub[5]);
			}else if ( preg_match("/^(.+?) (in|or|and|above|below|of|for|from|on) (.+?)$/ui",$str,$sub) ){
				$sw = '';
				$aw = strtolower($sub[1]);
				$jw = strtolower($sub[2]);
				$bw = strtolower($sub[3]);
			}else{
				break;
			}
		
			if ( $jw == 'in' ){			$str = $sw . $bw . '内の' . $aw;
			}else if ( $jw == 'or' ){	$str = $sw . $aw . 'か' . $bw;
			}else if ( $jw == 'and' ){	$str = $sw . $aw . 'と' . $bw;
			}else if ( $jw == 'on' ){	$str = $sw . $bw . 'の上の' . $aw;
			}else if ( $jw == 'above' ){$str = $sw . $bw . 'の上の' . $aw;
			}else if ( $jw == 'below' ){$str = $sw . $bw . 'の下の' . $aw;
			}else if ( $jw == 'of' ){	$str = $sw . $bw . 'の' . $aw;
			}else if ( $jw == 'for' ){	$str = $sw . $bw . 'の' . $aw;
			}else if ( $jw == 'from' ){	$str = $sw . $bw . 'からの' . $aw;
			}
			$cnt--;
		}

		// 固有単語(1文字) - 項目
		$str = str_ireplace("Categories", 'カテゴリー', $str);
		$str = str_ireplace("Category", 'カテゴリー', $str);
		$str = str_ireplace_s("Tag", 'タグ', $str);
		$str = str_ireplace_s("Comment", "コメント", $str);
		$str = str_ireplace_s("Permalink", 'パーマリンク', $str);

		// 固有単語(1文字) - 表示種別
		$str = str_ireplace_s("excerpt", '抜粋表示', $str);
		$str = str_ireplace("listing", '一覧', $str);
		$str = str_ireplace("list", '一覧表示', $str);
		$str = str_ireplace_s("tile", 'タイル表示', $str);
		$str = str_ireplace("mosaic", 'モザイク表示', $str);
		$str = str_ireplace_s("Author", '投稿者別', $str);

		// 固有単語(1文字) - 構成要素
		$str = str_ireplace_s("Layout", 'レイアウト', $str);
		$str = str_ireplace_s("Thumbnail", 'サムネイル', $str);
		$str = str_ireplace_s("Favicon", "お気に入りアイコン", $str);
		$str = str_ireplace_s("Icon", "アイコン", $str);
		$str = str_ireplace_s("Title", "タイトル", $str);
		$str = str_ireplace_s("Page", "ページ", $str);
		$str = str_ireplace_s("Text", "テキスト", $str);
		$str = str_ireplace_s("Post", "投稿", $str);

		// 固有単語(1文字) - 表示ブロック
		$str = str_ireplace_s("Sub-Header", "サブヘッダー", $str);
		$str = str_ireplace_s("Header", "ヘッダー", $str);
		$str = str_ireplace_s("Headline", "ヘッドライン", $str);
		$str = str_ireplace("Footer", "フッター", $str);
		$str = str_ireplace_s("Sidebar", "サイドバー", $str);
		$str = str_ireplace_s("Content", "コンテンツ", $str);
		$str = str_ireplace("Body", "本文", $str);
		$str = str_ireplace_s("Widget", "ウィジェット", $str);


		// 固有単語(1文字) - 装飾要素
		$str = str_ireplace("Color", "色", $str);
		$str = str_ireplace("Border", "境界線", $str);
		$str = str_ireplace("Decoration", "装飾", $str);
		$str = str_ireplace("Description", "説明", $str);
		$str = str_ireplace("Separator", "セパレーター", $str);

		// 固有単語(1文字) - 文書要素
		$str = str_ireplace_s("Font", "フォント", $str);
		$str = str_ireplace_s("Link", "リンク", $str);
		$str = str_ireplace("Visited", "訪問済み", $str);
		$str = str_ireplace("Highlighted", "ハイライト", $str);

		// 固有単語(1文字) - その他
		$str = str_ireplace("The ", "", $str);
		$str = str_ireplace_s("Type", "タイプ", $str);
		$str = str_ireplace("Scrolling", "スクロール", $str);
		$str = str_ireplace("Position", "位置", $str);
		$str = str_ireplace("General", "全般", $str);
		$str = str_ireplace("Custom", "カスタム", $str);
		$str = str_ireplace("value", "値", $str);
		$str = str_ireplace("main", "メイン", $str);
		$str = str_ireplace("Gallery", "ギャラリー", $str);

		$str = str_ireplace("Yearly", '年毎', $str);
		$str = str_ireplace("Monthly", '月毎', $str);
		$str = str_ireplace("weekly", '週毎', $str);
		$str = str_ireplace("Daily", '日毎', $str);

		$str = str_ireplace("Year", '年', $str);
		$str = str_ireplace("Month", '月', $str);
		$str = str_ireplace("Date", '日', $str);
		$str = str_ireplace("Top", "上部", $str);
		$str = str_ireplace("Bottom", "下部", $str);
		$str = str_ireplace("open", "開く", $str);
		$str = str_ireplace("close", "閉じる", $str);
		$str = str_ireplace_s("tab", "タブ", $str);
		$str = str_ireplace("order", "順序", $str);
		$str = str_ireplace_s("Archive", "アーカイブ", $str);
		$str = str_ireplace("grouping", "グループ分け", $str);
		$str = str_ireplace("Recent", "最近の", $str);
		$str = str_ireplace("Search", "検索", $str);
		$str = str_ireplace("path", "パス", $str);
		$str = str_ireplace_s("label", "ラベル", $str);

		$str = str_ireplace("entities", "エンティティ", $str);
		$str = str_ireplace("magazine", "マガジン", $str);
		$str = str_ireplace_s("template", "テンプレート", $str);

		$str = str_ireplace("Previous", "前", $str);
		$str = str_ireplace("Next", "次", $str);
		$str = str_ireplace_s("section", "部分", $str);

		$str = str_ireplace_s("width", "幅", $str);
		$str = str_ireplace_s("height", "高さ", $str);
		$str = str_ireplace_s("Column", "列", $str);
		$str = str_ireplace_s("Style", "スタイル", $str);
		$str = str_ireplace_s("Vertical", "垂直の", $str);
		$str = str_ireplace_s("Alignment", "配置", $str);
		$str = str_ireplace("Default", "デフォルトの", $str);
		$str = str_ireplace("Drag-and-Drop", "ドラッグ&ドロップ", $str);
		$str = str_ireplace("Expand / Collapse", "折りたたみ/展開", $str);
		$str = str_ireplace_s("Format", "書式", $str);
		$str = str_ireplace_s("Breadcrumbs", "パンくずリスト", $str);
		$str = str_ireplace_s("Analytics", "アナリティクス(分析)", $str);
		$str = str_ireplace("scaling", "拡大縮小", $str);
		$str = str_ireplace_s("image", "画像", $str);
		$str = str_ireplace_s("number", "番号", $str);
		$str = str_ireplace_s("maximum", "最大", $str);
 		$str = str_ireplace_s("Minimum", "最小", $str);
 		$str = str_ireplace_s("Bylines", "署名欄", $str);
 		$str = str_ireplace_s("setting", "設定", $str);
 		$str = str_ireplace("all", "全", $str);
 		$str = str_ireplace("each", "各", $str);
 		$str = str_ireplace_s("count", "数", $str);
 		$str = str_ireplace("Single", "単一", $str);
 		$str = str_ireplace("Introduction", "概要", $str);
 		$str = str_ireplace_s("Size", "サイズ", $str);
 		$str = str_ireplace_s("Attachment", "添付", $str);
 		$str = str_ireplace_s("Audio", "オーディオ", $str);
 		$str = str_ireplace_s("Application", "アプリケーション", $str);
 		$str = str_ireplace_s("Video", "動画", $str);
 		$str = str_ireplace_s("Sitemap", "サイトマップ", $str);
 		$str = str_ireplace_s("menu", "サイトマップ", $str);
 		$str = str_ireplace("blog", "ブログ", $str);
 		$str = str_ireplace("sequence", "順序", $str);
 		$str = str_ireplace("Library", "ライブラリー", $str);
 		$str = str_ireplace("adjustment", "調整", $str);
 		$str = str_ireplace("Background", "背景", $str);
 		$str = str_ireplace_s("Shadow", "影", $str);
 
 		$str = str_ireplace("Duplicate", "重複", $str);
 		$str = str_ireplace("Sticky", "固定", $str);
 		$str = str_ireplace("Block", "ブロック", $str);
 		$str = str_ireplace("Skinning", "スキンの適用", $str);
 		$str = str_ireplace("Typography", "文字体裁", $str);
 		$str = str_ireplace("Other Graphical Elements", "その他のグラフィカルな要素", $str);
 		$str = str_ireplace("Back-End", "バックエンド", $str);
 		$str = str_ireplace("Front", "フロントページ", $str);

		// 固有単語(1文字) - 装飾部分
		$str = str_ireplace("Download", 'ダウンロード(class="download")', $str);
		$str = str_ireplace("Announcement", 'アナウンス(class="announcement")', $str);
		$str = str_ireplace("Note", 'ノート(class="note")', $str);
		$str = str_ireplace("Warning", '警告(class="warning")', $str);
		$str = str_ireplace("Responsive", '柔軟な', $str);

		$str = str_ireplace(' ', '', $str);
//		return '"'.$str.'"';
		return $str.$back;
	}

	function str_ireplace_s($word,$change,$str) {
		$str = str_ireplace($word."s",$change,$str);
		$str = str_ireplace($word,$change,$str);
		return $str;
	}
?>
